/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc.document;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonObject;
import com.probejs.jdoc.IConditional;
import com.probejs.jdoc.ISerde;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.property.AbstractProperty;
import com.probejs.jdoc.property.PropertyComment;
import com.probejs.jdoc.property.PropertyHide;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractDocumentBase<T extends AbstractDocumentBase<T>>
implements ISerde {
    public static final BiMap<Class<? extends AbstractDocumentBase<?>>, String> DOCUMENT_TYPE_REGISTRY = HashBiMap.create();
    protected List<AbstractProperty<?>> properties = new ArrayList();

    public abstract T applyProperties();

    public T merge(T other) {
        if (this == other) {
            return other;
        }
        T document = ((AbstractDocumentBase)other).copy();
        this.properties.addAll(0, this.properties.stream().filter(prop -> prop instanceof PropertyComment).toList());
        return document;
    }

    public abstract T copy();

    @Override
    public JsonObject serialize() {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", (String)DOCUMENT_TYPE_REGISTRY.get(this.getClass()));
        Serde.serializeCollection(obj, "properties", this.properties, true);
        return obj;
    }

    @Override
    public void deserialize(JsonObject object) {
        Serde.deserializeDocuments(this.properties, object.get("properties"));
    }

    public final <P extends AbstractProperty<P>> Optional<P> findProperty(Class<P> property) {
        return this.properties.stream().filter(p -> p.getClass() == property).map(p -> p).findFirst();
    }

    public final <P extends AbstractProperty<P>> boolean hasProperty(Class<P> property) {
        return this.findProperty(property).isPresent();
    }

    public final List<AbstractProperty<?>> findProperties(Predicate<AbstractProperty<?>> predicate) {
        return this.properties.stream().filter(predicate).collect(Collectors.toList());
    }

    public final <E extends AbstractProperty<?>> List<E> findPropertiesOf(Class<E> property) {
        return this.properties.stream().filter(prop -> property.isAssignableFrom(prop.getClass())).map(prop -> prop).collect(Collectors.toList());
    }

    @HideFromJS
    public final void addProperty(AbstractProperty<?> property) {
        this.properties.add(property);
    }

    public final AbstractDocumentBase<T> addPropertyJson(JsonObject json) {
        this.addProperty(Serde.deserializeProperty(json));
        return this;
    }

    public final boolean fulfillsConditions() {
        return this.findProperties(prop -> prop instanceof IConditional).stream().allMatch(prop -> ((IConditional)((Object)prop)).test());
    }

    public final boolean isHidden() {
        return this.hasProperty(PropertyHide.class);
    }
}

